<?php

/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # p0wersurge.com presents a fresh release                          # ||
|| # ---------------------------------------------------------------- # ||
|| # CometChat 4                                                      # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

include dirname(dirname(dirname(__FILE__))).DIRECTORY_SEPARATOR."modules.php";
include dirname(__FILE__).DIRECTORY_SEPARATOR."config.php";

if ($rtl == 1) {
	$rtl = "_rtl";
} else {
	$rtl = "";
}

if (!file_exists(dirname(__FILE__)."/themes/".$theme."/games".$rtl.".css")) {
	$theme = "default";
}

$keywordlist = '';

if (!empty($keywords)) {
	$keywords = explode(',',$keywords);
	foreach ($keywords as $keyword) {
		$keyword = trim($keyword);
		$keyword = preg_replace('/[^\w\d_ -]/si', '', $keyword);
		$keywordlist .= '|'.$keyword.'';
	}
	$keywordlist = substr($keywordlist,1);
}

echo <<<EOD
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="-1">
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/> 
<link type="text/css" rel="stylesheet" media="all" href="themes/{$theme}/games{$rtl}.css" /> 
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js" type="text/javascript"></script>
<script>

var gamessource = {};
var gamesheight = {};
var gameswidth = {};
var categorygames = {};
var keywords = "{$keywordlist}";
var keywordmatch = new RegExp(keywords);

$(document).ready(function() {
	$.getJSON('contents.php?get=categories', function(data) {
		if (data == '0') {
			$("body").html('<iframe width="100%" height="294" frameborder="0" scrolling="no" allowtransparency="true" vspace="0" hspace="0" marginheight="0" marginwidth="0" src="http://www.heyzap.com/embed?embed_key=2b9c74ca22&special_height=300" style="margin-top:3px;" id="heyzap_iframe"></iframe>');
		} else {
			var categoriesinfo = '';
			for (x = 0;x<data.categories.length;x++) {	
				if (data.categories[x].name != 'multiplayer' && data.categories[x].name != 'lifestyle') {				
					categorygames[data.categories[x].name] = data.categories[x].num_games;
					categoriesinfo += '<li id=\''+data.categories[x].name+'\' onclick="javascript:getCategory(\''+data.categories[x].name+'\')">'+data.categories[x].display_name+'</li>';
				}
			}

			$('#categories').html(categoriesinfo);
			
			getCategory('featured');
		}
	});
}); 

function getCategory(catname,page){
	if (page == null) {
		page = 1;
	} else {
		page = parseInt(page);
	}
	
	$('#categories li').removeClass('catselected');
	$('#'+catname).addClass('catselected');

	$('#games').html('');
	$('#loader').css('display','block');

	$.getJSON('contents.php?get='+catname+'&page='+page, function(data) {
		
		$('#loader').css('display','none');
		for (x = 0;x<data.games.length;x++) {
			var name = data.games[x].display_name;
			var thumbnail = data.games[x].thumb_100x100;
			var width = data.games[x].width;
			var height = data.games[x].height;
			var source = data.games[x].embed_code;

			gamessource[x] = source;
			gamesheight[x] = height;
			gameswidth[x] = width;

			if (data.games[x].display_name.toLowerCase().match(keywordmatch) != null || data.games[x].description.toLowerCase().match(keywordmatch) != null) {
			} else {
 				$('#games').append('<div class="gamelist" onclick="javascript:loadGame(\''+x+'\')"><img src="'+thumbnail+'"><br/>'+name+'</div>');
			}
		}

		if (categorygames[catname] > (parseInt(page)+1)*20) {
			$('#games').append('<div class="gamelist" onclick="javascript:getCategory(\''+(catname)+'\',\''+parseInt(page+1)+'\')"><br/><br/><br/>Play more games</div>');
		}
	});
}

function loadGame(id) {
	w = window.open ('', 'singleplayergame',"status=0,toolbar=0,menubar=0,directories=0,resizable=0,location=0,status=0,scrollbars=0, width="+gameswidth[id]+",height="+gamesheight[id]); 
	w.document.write('<html><style>html, body {padding:0;margin:0;overflow:hidden;}</style>');
	w.document.write(gamessource[id]);
}


</script>

</head>
<body>
<div style="width:100%;margin:0 auto;margin-top: 0px;">

<div id="container">
<div id="categories"></div>
<div id="games"></div>
<div style="clear:both"></div>
</div>
</div>
<div id="loader"></div>
</body>
</html>
EOD;
?>